/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.zb;

import com.gprinter.zb.ZebraImageInternal;
import java.io.IOException;
import java.io.OutputStream;

public class DitheredImageProvider {
    public static void getDitheredImage(ZebraImageInternal Image, OutputStream var1) throws IOException {
        int w = Image.getWidth();
        int h = Image.getHeight();
        DitheredImageProvider.getDitheredImage(w, h, Image, var1);
    }

    protected static void getDitheredImage(int width, int height, ZebraImageInternal var2, OutputStream outputStream) throws IOException {
        int i;
        int[] w = var2.getRow(0);
        int[] h = var2.getRow(1);
        int ww = width / 8 + (width % 8 == 0 ? 0 : 1);
        int pix = 8 - width % 8;
        if (pix == 8) {
            pix = 0;
        }
        byte[] var8 = new byte[ww];
        int var9 = 0;
        for (i = 0; i < width; ++i) {
            w[i] = DitheredImageProvider.convertByteToGrayscale(w[i]);
        }
        for (i = 0; i < height; ++i) {
            int var11;
            for (var11 = 0; var11 < var8.length; ++var11) {
                var8[var11] = 0;
            }
            var11 = 0;
            for (int var12 = 0; var12 < width; ++var12) {
                if (var12 % 8 == 0) {
                    var9 = -128;
                }
                int var13 = w[var12];
                var11 = var12 / 8;
                int var14 = var13 >= 128 ? -1 : 0;
                var8[var11] = (byte)(var8[var11] | var9 & var14);
                int var15 = var13 - (var14 & 0xFF);
                if (var12 < width - 1) {
                    int n = var12 + 1;
                    w[n] = w[n] + 7 * var15 / 16;
                }
                if (var12 > 0 && i < height - 1) {
                    int n = var12 - 1;
                    h[n] = h[n] + 3 * var15 / 16;
                }
                if (i < height - 1) {
                    if (var12 == 0) {
                        h[var12] = DitheredImageProvider.convertByteToGrayscale(h[var12]);
                    }
                    int n = var12;
                    h[n] = h[n] + 5 * var15 / 16;
                }
                if (i < height - 1 && var12 < width - 1) {
                    h[var12 + 1] = DitheredImageProvider.convertByteToGrayscale(h[var12 + 1]);
                    int n = var12 + 1;
                    h[n] = h[n] + 1 * var15 / 16;
                }
                var9 = (byte)((var9 & 0xFF) >>> 1);
            }
            var8[var11] = (byte)(var8[var11] | 255 >>> 8 - pix);
            outputStream.write(var8);
            w = h;
            h = var2.getRow(i + 2);
        }
    }

    private static int convertByteToGrayscale(int var0) {
        int r = (var0 & 0xFF0000) >>> 16;
        int g = (var0 & 0xFF00) >>> 8;
        int b = var0 & 0xFF;
        int gray = (r * 30 + g * 59 + b * 11) / 100;
        if (gray > 255) {
            gray = 255;
        } else if (gray < 0) {
            gray = 0;
        }
        return gray;
    }
}

